#ifndef AHLGREN_UNIFICATION
#define AHLGREN_UNIFICATION

#include <set>

#include "functor.h"
#include "substitution.h"


namespace lp {
	using namespace std;

	// Are expressions f1 and f2 unifiable?
	bool unify(const Functor* f1, const Functor* f2);	
	// Check if expressions are unifiable with substitutions subs (does NOT expand subs)
	bool unify(const Functor* f1, const Functor* f2, Subst& subs);
	// Unify f1 with f2, get subs and bindings (does NOT expand the unifiers)
	bool unify(const Functor* f1, const Functor* f2, Subst& subs, set<id_type>& bindings);
	// Unify variable with expression
	bool unify_var(id_type var_id, const Functor* f, Subst& subs, set<id_type>& bindings);

	// Shallow unification algorithm (does not deepen the bindings)
	bool shallow_unify(const Functor* f1, const Functor* f2, Subst& subs, set<id_type>& bindings);
	// Variable Unification Algorithm (should not be called immediately)
	bool shallow_unify_var(id_type var_id, const Functor* f2, Subst& subs, set<id_type>& bindings);
	
	// Occur Check Algorithm - does var occur in subs(expr)?
	bool occurs_check(id_type var, const Functor* expr, const Subst& subs);
	
	// Can expression f1 be matched to f2?
	bool match(const Functor* f1, const Functor* f2);	
	// Try to Match f1 to f2, getting a MGU subs
	bool match(const Functor* f1, const Functor* f2, Subst& subs);
	// Match f1 to f2 with subs and bindings
	bool match(const Functor* f1, const Functor* f2, Subst& subs, set<id_type>& bindings);
	// Matching Algorithm (should not be called immediately)
	bool shallow_match(const Functor* f1, const Functor* f2, Subst& subs, set<id_type>& bindings);
	// Variable Matching Algorithm (should not be called immediately)
	bool shallow_match_var(id_type var_id, const Functor* f2, Subst& subs, set<id_type>& bindings);

}


#endif

